/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.rules.ZeroR;
import weka.core.Check;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CheckOptionHandler
extends Check {
    protected OptionHandler m_OptionHandler = new ZeroR();
    protected String[] m_UserOptions = new String[0];
    protected boolean m_Success;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tFull name of the OptionHandler analysed.\n\teg: weka.classifiers.rules.ZeroR\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        if (this.m_OptionHandler != null) {
            result.addElement(new Option("", "", 0, "\nOptions specific to option handler " + this.m_OptionHandler.getClass().getName() + ":"));
            Enumeration enm = this.m_OptionHandler.listOptions();
            while (enm.hasMoreElements()) {
                result.addElement((Option)enm.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = ZeroR.class.getName();
        }
        this.setUserOptions(Utils.partitionOptions(options));
        this.setOptionHandler((OptionHandler)Utils.forName(OptionHandler.class, tmpStr, null));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        if (this.getOptionHandler() != null) {
            result.add("-W");
            result.add(this.getOptionHandler().getClass().getName());
        }
        if (this.m_OptionHandler != null) {
            options = this.m_OptionHandler.getOptions();
            result.add("--");
            i = 0;
            while (i < options.length) {
                result.add(options[i]);
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptionHandler(OptionHandler value) {
        this.m_OptionHandler = value;
    }

    public OptionHandler getOptionHandler() {
        return this.m_OptionHandler;
    }

    public void setUserOptions(String[] value) {
        this.m_UserOptions = this.getCopy(value);
    }

    public String[] getUserOptions() {
        return this.getCopy(this.m_UserOptions);
    }

    public boolean getSuccess() {
        return this.m_Success;
    }

    protected String printOptions(String[] options) {
        if (options == null) {
            return "<null>";
        }
        return Utils.joinOptions(options);
    }

    protected void compareOptions(String[] options1, String[] options2) throws Exception {
        if (options1 == null) {
            throw new Exception("first set of options is null!");
        }
        if (options2 == null) {
            throw new Exception("second set of options is null!");
        }
        if (options1.length != options2.length) {
            throw new Exception("problem found!\nFirst set: " + this.printOptions(options1) + '\n' + "Second set: " + this.printOptions(options2) + '\n' + "options differ in length");
        }
        int i = 0;
        while (i < options1.length) {
            if (!options1[i].equals(options2[i])) {
                throw new Exception("problem found!\n\tFirst set: " + this.printOptions(options1) + '\n' + "\tSecond set: " + this.printOptions(options2) + '\n' + '\t' + options1[i] + " != " + options2[i]);
            }
            ++i;
        }
    }

    protected String[] getCopy(String[] options) {
        String[] result = new String[options.length];
        System.arraycopy(options, 0, result, 0, options.length);
        return result;
    }

    protected OptionHandler getDefaultHandler() {
        OptionHandler result;
        try {
            result = (OptionHandler)this.m_OptionHandler.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected String[] getDefaultOptions() {
        String[] result;
        OptionHandler o = this.getDefaultHandler();
        if (o == null) {
            this.println("WARNING: couldn't create default handler, cannot use default options!");
            result = new String[]{};
        } else {
            result = o.getOptions();
        }
        return result;
    }

    public boolean checkListOptions() {
        boolean result;
        block4: {
            this.print("ListOptions...");
            try {
                Enumeration enu = this.getOptionHandler().listOptions();
                if (this.getDebug() && enu.hasMoreElements()) {
                    this.println("");
                }
                while (enu.hasMoreElements()) {
                    Option option = (Option)enu.nextElement();
                    if (!this.getDebug()) continue;
                    this.println(option.synopsis());
                    this.println(option.description());
                }
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block4;
                this.println(e);
            }
        }
        return result;
    }

    public boolean checkSetOptions() {
        boolean result;
        block2: {
            this.print("SetOptions...");
            try {
                this.getDefaultHandler().setOptions(this.getUserOptions());
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block2;
                this.println(e);
            }
        }
        return result;
    }

    public boolean checkDefaultOptions() {
        boolean result;
        block2: {
            this.print("Default options...");
            String[] options = this.getDefaultOptions();
            try {
                this.getDefaultHandler().setOptions(options);
                Utils.checkForRemainingOptions(options);
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block2;
                this.println(e);
            }
        }
        return result;
    }

    public boolean checkRemainingOptions() {
        boolean result;
        block3: {
            this.print("Remaining options...");
            String[] options = this.getUserOptions();
            try {
                this.getDefaultHandler().setOptions(options);
                if (this.getDebug()) {
                    this.println("\n  remaining: " + this.printOptions(options));
                }
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block3;
                this.println(e);
            }
        }
        return result;
    }

    public boolean checkCanonicalUserOptions() {
        boolean result;
        block6: {
            this.print("Canonical user options...");
            try {
                OptionHandler handler = this.getDefaultHandler();
                handler.setOptions(this.getUserOptions());
                if (this.getDebug()) {
                    this.print("\n  Getting canonical user options: ");
                }
                String[] userOptions = handler.getOptions();
                if (this.getDebug()) {
                    this.println(this.printOptions(userOptions));
                }
                if (this.getDebug()) {
                    this.println("  Setting canonical user options");
                }
                handler.setOptions((String[])userOptions.clone());
                if (this.getDebug()) {
                    this.println("  Checking canonical user options");
                }
                String[] userOptionsCheck = handler.getOptions();
                this.compareOptions(userOptions, userOptionsCheck);
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block6;
                this.println(e);
            }
        }
        return result;
    }

    public boolean checkResettingOptions() {
        boolean result;
        block5: {
            this.print("Resetting options...");
            try {
                if (this.getDebug()) {
                    this.println("\n  Setting user options");
                }
                OptionHandler handler = this.getDefaultHandler();
                handler.setOptions(this.getUserOptions());
                String[] defaultOptions = this.getDefaultOptions();
                if (this.getDebug()) {
                    this.println("  Resetting to default options");
                }
                handler.setOptions(this.getCopy(defaultOptions));
                if (this.getDebug()) {
                    this.println("  Checking default options match previous default");
                }
                String[] defaultOptionsCheck = handler.getOptions();
                this.compareOptions(defaultOptions, defaultOptionsCheck);
                this.println("yes");
                result = true;
            }
            catch (Exception e) {
                this.println("no");
                result = false;
                if (!this.getDebug()) break block5;
                this.println(e);
            }
        }
        return result;
    }

    @Override
    public void doTests() {
        this.println("OptionHandler: " + this.m_OptionHandler.getClass().getName() + "\n");
        if (this.getDebug()) {
            this.println("--> Info");
            this.print("Default options: ");
            this.println(this.printOptions(this.getDefaultOptions()));
            this.print("User options: ");
            this.println(this.printOptions(this.getUserOptions()));
        }
        this.println("--> Tests");
        this.m_Success = this.checkListOptions();
        if (this.m_Success) {
            this.m_Success = this.checkSetOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkDefaultOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkRemainingOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkCanonicalUserOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkResettingOptions();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        CheckOptionHandler check = new CheckOptionHandler();
        CheckOptionHandler.runCheck(check, args);
        if (check.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

